package com.ejie.aa17a.converter;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.convert.converter.Converter;

import com.ejie.x38.util.DateTimeManager;

/**
 * @author Ander.Vegas
 * 
 */
public class Aa17aDateConverter implements Converter<String, Date> {

	/**
	 * Method 'convert'.- convierte una fecha contenida en un String a un objeto
	 * Date
	 * 
	 * @param strFecha
	 *            String
	 * @return Date
	 */
	public Date convert(String strFecha) {
		String strFechaAux = strFecha;
		if (strFecha != null) {
			strFechaAux = strFechaAux.trim();
		}
		if ("".equals(strFechaAux)) {
			// Si el String strFechaAux es "" devolvemos null porque si no daría
			// un
			// ParseException en el Controller cuando se utiliza el tag
			// "ModelAttribute"
			return null;
		}
		try {
			Locale locale = LocaleContextHolder.getLocale();
			SimpleDateFormat format = DateTimeManager.getDateTimeFormat(locale);
			return format.parse(strFechaAux);
		} catch (ParseException ex) {
			ex.printStackTrace();
			throw new IllegalArgumentException();
		}
	}

}